import pandas as pd, numpy as np, matplotlib.pyplot as plt
dfu = pd.read_csv("outputs/rar_unscaled.csv")
m = np.isfinite(dfu["g_bar"]) & np.isfinite(dfu["g_obs"])
if "used_in_window" in dfu.columns: m &= dfu["used_in_window"].values
x = np.log10(dfu.loc[m,"g_bar"].values); y = np.log10(dfu.loc[m,"g_obs"].values)
plt.figure(); plt.scatter(x,y,s=6,alpha=0.5)
plt.xlabel("log10 g_bar"); plt.ylabel("log10 g_obs"); plt.title("RAR (unscaled)")
plt.savefig("figures/rar_unscaled.png", dpi=160, bbox_inches="tight")
print("Saved figures/rar_unscaled.png")

dfs = pd.read_csv("outputs/rar_ARscaled.csv")
m2 = np.isfinite(dfs["gbar_scaled"]) & np.isfinite(dfs["gobs_scaled"])
if "used_in_window" in dfs.columns: m2 &= dfs["used_in_window"].values
x2 = np.log10(dfs.loc[m2,"gbar_scaled"].values); y2 = np.log10(dfs.loc[m2,"gobs_scaled"].values)
plt.figure(); plt.scatter(x2,y2,s=6,alpha=0.5)
plt.xlabel("log10 (g_bar/g*)"); plt.ylabel("log10 (g_obs/g*)"); plt.title("RAR (AR-scaled)")
plt.savefig("figures/rar_scaled.png", dpi=160, bbox_inches="tight")
print("Saved figures/rar_scaled.png")
